# RetinexNet
本代码实现了RetinexNet算法

Deep Retinex Decomposition for Low-Light Enhancement. In BMVC'18 (Oral Presentation)
[Chen Wei*](https://weichen582.github.io/), [Wenjing Wang*](https://daooshee.github.io/website/), [Wenhan Yang](https://flyywh.github.io/), [Jiaying Liu](http://www.icst.pku.edu.cn/struct/people/liujiaying.html). 

[Paper](https://arxiv.org/abs/1808.04560), [Project Page & Dataset](https://daooshee.github.io/BMVC2018website/)

### 运行环境 ###
1. Python
2. Tensorflow >= 1.5.0
3. numpy, PIL

### 测试 ###
可以运行以下命令使用自定义的图像数据训练模型：
```shell
python main.py 
    --use_gpu=1 \                           # use gpu or not
    --gpu_idx=0 \
    --gpu_mem=0.5 \                         # gpu memory usage
    --phase=test \
    --test_dir=/path/to/your/test/dir/ \
    --save_dir=/path/to/save/results/ \
    --decom=0                               # save only enhanced results or together with decomposition results
```
可以运行以下命令查看示例程序：
```shell
python main.py --phase=test
```
结果将会保存在 ```./test_results/```。

### 训练 ###
首先下载训练集[项目网站](https://daooshee.github.io/BMVC2018website/)。将LOL数据集的训练数据保存至目录`./data/our485/`, 同时将合成数据保存至`./data/syn/`。
之后，运行：
```shell
python main.py
    --use_gpu=1 \                           # use gpu or not
    --gpu_idx=0 \
    --gpu_mem=0.5 \                         # gpu memory usage
    --phase=train \
    --epoch=100 \                           # number of training epoches
    --batch_size=16 \
    --patch_size=48 \                       # size of training patches
    --start_lr=0.001 \                      # initial learning rate for adm
    --eval_every_epoch=20 \                 # evaluate and save checkpoints for every # epoches
    --checkpoint_dir=./checkpoint           # if it is not existed, automatically make dirs
    --sample_dir=./sample                   # dir for saving evaluation results during training
 ```
 
 ### 引用 ###
 ```
 @inproceedings{Chen2018Retinex,
  title={Deep Retinex Decomposition for Low-Light Enhancement},
  author={Chen Wei, Wenjing Wang, Wenhan Yang, Jiaying Liu},
  booktitle={British Machine Vision Conference},
  year={2018},
  organization={British Machine Vision Association}
}
```
 
